<!-- Update Lesson Modal -->
<div class="modal fade" id="update_lesson_modal_<?php echo e($item->id); ?>" tabindex="-1"
    aria-labelledby="update_lesson_modal_label" aria-hidden="true">
    <div class="modal-dialog modal-lg">


        <form id="sessionLessonFormUpdate"
            action="<?php echo e(route('track_levels_sessions_lessons_update', ['id' => $item->id])); ?>" method="POST"
            enctype="multipart/form-data">
            <?php echo method_field('PUT'); ?>
            <?php echo csrf_field(); ?>
            <div class="modal-content">

                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="update_lesson_modal_label"><?php echo app('translator')->get('academics.update_lesson'); ?>
                    </h1>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">

                    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

                    <div class="primary_input">
                        <label class="primary_input_label" for="name"><?php echo app('translator')->get('academics.lesson_name'); ?>

                        </label>
                        <input class="primary_input_field form-control" type="text" value="<?php echo e($item->name); ?>"
                            name="name" id="lesson_name" autocomplete="off">
                    </div>
                    <div class="primary_input">
                        <label class="primary_input_label" for="duration"><?php echo app('translator')->get('academics.duration_in_minute'); ?>

                        </label>
                        <input class="primary_input_field form-control" type="text" name="duration"
                            id="lesson_duration" value="<?php echo e($item->duration); ?>" autocomplete="off">
                    </div>

                    <?php
                        $hostTypeEnum = DB::select("SHOW COLUMNS FROM session_lessons WHERE Field = 'host_type'")[0]
                            ->Type;
                        preg_match('/^enum\((.*)\)$/', $hostTypeEnum, $matches);
                        $hostTypes = array_map(fn($value) => trim($value, "'"), explode(',', $matches[1]));

                    ?>

                    <div class="primary_input">
                        <label class="primary_input_label" for="">
                            <?php echo app('translator')->get('academics.host'); ?>
                        </label>
                        <select class="primary_select form-control" name="host_type"
                            id="lesson_host_type_<?php echo e($item->id); ?>">
                            <option value=""><?php echo app('translator')->get('common.select'); ?></option>
                            <?php $__currentLoopData = $hostTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($type); ?>" <?php echo e($item->host_type == $type ? 'selected' : ''); ?>>
                                    <?php echo e(ucfirst($type)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </select>
                    </div>



                    <div id="youtubeUrlDiv_<?php echo e($item->id); ?>">

                    </div>

                    <div id="fileUploadDiv_<?php echo e($item->id); ?>">

                    </div>

                    <div class="primary_input">
                        <label class="primary_input_label" for=""><?php echo app('translator')->get('academics.privacy'); ?></label>
                        <select class="primary_select form-control" name="privacy" id="lesson_privacy">
                            <option value=""><?php echo app('translator')->get('common.select'); ?></option>

                            <?php
                                $enumValues = DB::select("SHOW COLUMNS FROM session_lessons WHERE Field = 'privacy'")[0]
                                    ->Type;
                                preg_match('/^enum\((.*)\)$/', $enumValues, $matches);
                                $privacyOptions = array_map(fn($value) => trim($value, "'"), explode(',', $matches[1]));

                            ?>

                            <?php $__currentLoopData = $privacyOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($option); ?>" <?php echo e($item->privacy == $option ? 'selected' : ''); ?>>
                                    <?php echo e(ucfirst($option)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>


                    <div class="primary_input">
                        <label class="primary_input_label" for="description"><?php echo app('translator')->get('academics.description'); ?>

                        </label>

                        <textarea class="primary_input_field form-control" name="description" id="lesson_description" rows="5"><?php echo e($item->description); ?></textarea>

                    </div>
                </div>
                <div class="modal-footer">

                    <button type="submit" id="sessionLessonFormBtnUpdate" class="primary-btn fix-gr-bg text-nowrap">
                        <?php echo app('translator')->get('common.update'); ?>
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>



<style>
    .item_header {
        background: #415094;

    }

    .item_header .pull-left {
        color: #fff;
    }

    .item_header .primary-btn {
        color: #fff;

    }

    .item_header .collapge_arrow_normal {
        color: #fff;

    }
</style>
<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function() {
            $(document).ready(function() {
                var selectedHostType = $('#lesson_host_type_<?php echo e($item->id); ?>').val();
                toggleHostFields(selectedHostType);
                $('#lesson_host_type_<?php echo e($item->id); ?>').change(function() {
                    var selectedHostType = $(this).val();
                    toggleHostFields(selectedHostType);
                });

                function toggleHostFields(hostType) {
                    if (hostType === "youtube") {
                        $('#youtubeUrlDiv_<?php echo e($item->id); ?>').html(`
               <div class="primary_input">
                   <label class="primary_input_label" for="host_path_url"><?php echo app('translator')->get('common.url'); ?></label>
                   <input class="primary_input_field form-control" id="host_path_url" type="text" name="host_path" value="<?php echo e($item->host_path); ?>" placeholder="Enter YouTube URL" autocomplete="off">
               </div>
           `);
                        $('#fileUploadDiv_<?php echo e($item->id); ?>').empty();
                    } else if (hostType !== "") {
                        $('#fileUploadDiv_<?php echo e($item->id); ?>').html(`
               <div class="primary_input">
                   <label for="host_path_file" class="primary_input_label"><?php echo app('translator')->get('common.file'); ?></label>
                   <input class="primary_input_field form-control" type="file" name="host_path" id="host_path_file" value="<?php echo e($item->host_path); ?>">
                   <small>Current file: <a target="_blank" href="/<?php echo e($item->host_path); ?>"><i class="fa fa-eye"></i> <?php echo app('translator')->get('common.view_file'); ?></a>  </small>
               </div>
           `);
                        $('#youtubeUrlDiv_<?php echo e($item->id); ?>').empty();
                    }
                }
            });


            $(document).ready(function() {

                $("#sessionLessonFormUpdate").on('submit', function(event) {
                    event.preventDefault();

                    var formData = new FormData(this);
                    var hostType = $('[id^="lesson_host_type_"]').val();


                    if (hostType === "youtube") {
                        var hostUrl = $("#host_path_url");
                        if (hostUrl.length > 0) {
                            formData.append("host_path", hostUrl.val());
                        } else {
                            toastr.error("Host URL input is missing.");
                            return;
                        }
                    } else {
                        var hostFile = $("#host_path_file")[0];
                        if (hostFile && hostFile.files.length > 0) {
                            formData.append("host_path", hostFile.files[0]);
                        }
                    }
                });
            });

        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH D:\tailors-dev\upedia\resources\views/backEnd/academics/sessions/modals/update_lesson_modal.blade.php ENDPATH**/ ?>