<!-- Update Assignment Modal -->
<div class="modal fade" id="update_assignment_modal_<?php echo e($item->id); ?>" tabindex="-1"
    aria-labelledby="update_assignment_modal_label" aria-hidden="true">
    <div class="modal-dialog modal-lg">


        <form id="sessionAssignmentFormUpdate"
            action="<?php echo e(route('track_levels_sessions_assignment_update', ['id' => $item->id])); ?>" method="POST"
            enctype="multipart/form-data">
            <?php echo method_field('PUT'); ?>
            <?php echo csrf_field(); ?>
            <div class="modal-content">

                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="update_assignment_modal_label"><?php echo app('translator')->get('academics.update_assignment'); ?>
                    </h1>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">

                    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">


                    <div class="primary_input">
                        <label class="primary_input_label" for="title"><?php echo app('translator')->get('academics.title'); ?>

                        </label>
                        <input class="primary_input_field form-control" type="text" value="<?php echo e($item->title); ?>"
                            name="title">
                    </div>


                    <div class="row">
                        <div class="col primary_input">
                            <label class="primary_input_label" for="marks"><?php echo app('translator')->get('academics.marks'); ?>

                            </label>
                            <input class="primary_input_field form-control" type="number" value="<?php echo e($item->marks); ?>"
                                name="marks">
                        </div>
                        <div class="col primary_input">
                            <label class="primary_input_label" for="min_percentage"><?php echo app('translator')->get('academics.min_percentage'); ?>

                            </label>
                            <input class="primary_input_field form-control" type="number"
                                value="<?php echo e($item->min_percentage); ?>" name="min_percentage">
                        </div>
                    </div>


                    <div class="row">
                        <div class="col primary_input">
                            <label class="primary_input_label" for="attachment"><?php echo app('translator')->get('academics.attachment'); ?>

                            </label>
                            <input class="primary_input_field form-control" type="file" name="attachment">
                            <small>Current file: <a target="_blank" href="/<?php echo e($item->attachment); ?>"><i
                                        class="fa fa-eye"></i> <?php echo app('translator')->get('common.view_file'); ?></a> </small>
                        </div>


                        <div class="col primary_input">
                            <label class="primary_input_label" for="submit_date"><?php echo app('translator')->get('academics.submit_date'); ?>

                            </label>
                            <input class="primary_input_field form-control" type="date"
                                value="<?php echo e($item->submit_date); ?>" name="submit_date">
                        </div>
                    </div>


                    <div class="primary_input">
                        <label class="primary_input_label" for="description"><?php echo app('translator')->get('academics.description'); ?>

                        </label>
                        <textarea class="primary_input_field form-control" name="description" rows="5"><?php echo e($item->description); ?></textarea>
                    </div>

                    <div class="primary_input">
                        <label class="primary_input_label" for=""><?php echo app('translator')->get('academics.privacy'); ?></label>
                        <select class="primary_select form-control" name="privacy" id="assignment_privacy">
                            <option value=""><?php echo app('translator')->get('common.select'); ?></option>

                            <?php
                                $enumValues = DB::select(
                                    "SHOW COLUMNS FROM session_assignments WHERE Field = 'privacy'",
                                )[0]->Type;
                                preg_match('/^enum\((.*)\)$/', $enumValues, $matches);
                                $privacyOptions = array_map(fn($value) => trim($value, "'"), explode(',', $matches[1]));

                            ?>

                            <?php $__currentLoopData = $privacyOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($option); ?>" <?php echo e($item->privacy == $option ? 'selected' : ''); ?>>
                                    <?php echo e(ucfirst($option)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                </div>
                <div class="modal-footer">

                    <button type="submit" id="sessionAssignmentFormBtnUpdate"
                        class="primary-btn fix-gr-bg text-nowrap">
                        <?php echo app('translator')->get('common.update'); ?>
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>



<style>
    .item_header {
        background: #415094;

    }

    .item_header .pull-left {
        color: #fff;
    }

    .item_header .primary-btn {
        color: #fff;

    }

    .item_header .collapge_arrow_normal {
        color: #fff;

    }
</style>
<?php $__env->startPush('script'); ?>
    <script></script>
<?php $__env->stopPush(); ?>
<?php /**PATH D:\tailors-dev\upedia\resources\views/backEnd/academics/sessions/modals/update_assignment_modal.blade.php ENDPATH**/ ?>